@extends('installer.layout')

@section('title', 'Welcome')
@section('subtitle', 'Welcome to the Installation Wizard')

@section('content')
    <div style="text-align: center;">
        <div class="welcome-icon">
            <i class="fas fa-rocket"></i>
        </div>
        
        <h2 style="margin-bottom: var(--spacing-lg); color: var(--white);">Welcome to the Installation Process</h2>
        
        <p style="margin-bottom: var(--spacing-lg);">
            This wizard will guide you through configuring your application in just a few simple steps.
        </p>
    </div>
    
    <div class="feature-list">
        <div class="feature-item">
            <div class="feature-icon">
                <i class="fas fa-check"></i>
            </div>
            <div class="feature-text">
                <strong>Server Requirements</strong> - We'll check if your server meets all the requirements.
            </div>
        </div>
        
        <div class="feature-item">
            <div class="feature-icon">
                <i class="fas fa-check"></i>
            </div>
            <div class="feature-text">
                <strong>License Verification</strong> - Verify your product license key.
            </div>
        </div>
        
        <div class="feature-item">
            <div class="feature-icon">
                <i class="fas fa-check"></i>
            </div>
            <div class="feature-text">
                <strong>Database Configuration</strong> - Set up your database connection.
            </div>
        </div>
        
        <div class="feature-item">
            <div class="feature-icon">
                <i class="fas fa-check"></i>
            </div>
            <div class="feature-text">
                <strong>Application Settings</strong> - Configure your application.
            </div>
        </div>
    </div>
    
    <p style="text-align: center; margin-top: var(--spacing-lg);">
        Ready to get started? Click the button below to begin.
    </p>
@endsection

@section('footer')
    <div></div>
    <a href="{{ route('installer.requirements') }}" class="btn btn-primary">
        <i class="fas fa-arrow-right"></i> Begin Installation
    </a>
@endsection